/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractSAML2AttributeEncoder;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2StringAttributeEncoder
extends AbstractSAML2AttributeEncoder {
    private final Logger log = LoggerFactory.getLogger(SAML2StringAttributeEncoder.class);
    private final XMLObjectBuilder<XSString> stringBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);

    public Attribute encode(BaseAttribute attribute) {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        this.populateAttribute(samlAttribute);
        for (Object o : attribute.getValues()) {
            String attributeValue;
            if (o == null || DatatypeHelper.isEmpty((String)(attributeValue = o.toString()))) continue;
            XSString samlAttributeValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            samlAttributeValue.setValue(attributeValue);
            samlAttribute.getAttributeValues().add(samlAttributeValue);
        }
        List attributeValues = samlAttribute.getAttributeValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("Unable to encode {} attribute.  It does not contain any values", (Object)attribute.getId());
            return null;
        }
        return samlAttribute;
    }
}

