/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session.impl;

import edu.internet2.middleware.shibboleth.common.session.impl.AbstractSession;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.ServiceInformation;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
extends AbstractSession
implements Session {
    private static final long serialVersionUID = 2927868242208211623L;
    private byte[] sessionSecret;
    private Map<String, AuthenticationMethodInformation> authnMethods;
    private Map<String, ServiceInformation> servicesInformation;

    public SessionImpl(String sessionId, byte[] secret, long timeout) {
        super(sessionId, timeout);
        this.sessionSecret = secret;
        this.authnMethods = new ConcurrentHashMap<String, AuthenticationMethodInformation>(2);
        this.servicesInformation = new ConcurrentHashMap<String, ServiceInformation>(2);
    }

    @Override
    public synchronized byte[] getSessionSecret() {
        return this.sessionSecret;
    }

    @Override
    public synchronized Map<String, AuthenticationMethodInformation> getAuthenticationMethods() {
        return this.authnMethods;
    }

    @Override
    public synchronized Map<String, ServiceInformation> getServicesInformation() {
        return this.servicesInformation;
    }

    public synchronized ServiceInformation getServiceInformation(String entityId) {
        return this.servicesInformation.get(entityId);
    }
}

