/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session.impl;

import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.ServiceInformation;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class ServiceInformationImpl
implements ServiceInformation {
    private static final long serialVersionUID = 1185342879825302743L;
    private String entityID;
    private long authenticationInstant;
    private AuthenticationMethodInformation methodInfo;

    public ServiceInformationImpl(String id, DateTime loginInstant, AuthenticationMethodInformation method) {
        this.entityID = id;
        this.authenticationInstant = loginInstant.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        this.methodInfo = method;
    }

    public synchronized String getEntityID() {
        return this.entityID;
    }

    public synchronized DateTime getLoginInstant() {
        return new DateTime(this.authenticationInstant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public synchronized AuthenticationMethodInformation getAuthenticationMethod() {
        return this.methodInfo;
    }

    public synchronized int hashCode() {
        return this.entityID.hashCode();
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceInformation)) {
            return false;
        }
        ServiceInformation si = (ServiceInformation)obj;
        return this.entityID.equals(si.getEntityID());
    }
}

