/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml1.AttributeQueryConfiguration;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.AbstractSAML1ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.BaseSAML1ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import java.util.ArrayList;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml1.core.AttributeQuery;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.Request;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeQueryProfileHandler
extends AbstractSAML1ProfileHandler {
    private final Logger log = LoggerFactory.getLogger(AttributeQueryProfileHandler.class);
    private SAMLObjectBuilder<AssertionConsumerService> acsEndpointBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml1:query:attribute";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        Response samlResponse;
        AttributeQueryContext requestContext = new AttributeQueryContext();
        try {
            this.decodeRequest(requestContext, inTransport, outTransport);
            if (requestContext.getProfileConfiguration() == null) {
                this.log.error("SAML 1 Attribute Query profile is not configured for relying party " + requestContext.getInboundMessageIssuer());
                requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, StatusCode.REQUEST_DENIED, "SAML 1 Attribute Query profile is not configured for relying party " + requestContext.getInboundMessageIssuer()));
                samlResponse = this.buildErrorResponse(requestContext);
            } else {
                AuthenticationMethodInformation authnInfo;
                this.resolvePrincipal(requestContext);
                Session idpSession = (Session)this.getSessionManager().getSession(requestContext.getPrincipalName());
                if (idpSession != null && (authnInfo = idpSession.getAuthenticationMethods().get(requestContext.getInboundMessageIssuer())) != null) {
                    requestContext.setPrincipalAuthenticationMethod(authnInfo.getAuthenticationMethod());
                }
                this.resolveAttributes(requestContext);
                requestContext.setReleasedAttributes(requestContext.getAttributes().keySet());
                ArrayList<Statement> statements = new ArrayList<Statement>();
                AttributeStatement attributeStatement = this.buildAttributeStatement(requestContext, "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
                if (attributeStatement != null) {
                    statements.add((Statement)attributeStatement);
                }
                samlResponse = this.buildResponse(requestContext, statements);
            }
        }
        catch (ProfileException e) {
            samlResponse = this.buildErrorResponse(requestContext);
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected void decodeRequest(AttributeQueryContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoding message with decoder binding {}", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        requestContext.setCommunicationProfileId(this.getProfileId());
        MetadataProvider metadataProvider = this.getMetadataProvider();
        requestContext.setMetadataProvider(metadataProvider);
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        try {
            try {
                SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
                requestContext.setMessageDecoder(decoder);
                decoder.decode((MessageContext)requestContext);
                this.log.debug("Decoded request");
                Request request = (Request)requestContext.getInboundSAMLMessage();
                if (request == null || !(request instanceof Request) || request.getAttributeQuery() == null) {
                    this.log.error("Incoming message was not an Attribute request");
                    requestContext.setFailureStatus(this.buildStatus(StatusCode.REQUESTER, null, "Invalid SAML Attribute Request message."));
                    throw new ProfileException("Invalid SAML Attribute Request message.");
                }
            }
            catch (MessageDecodingException e) {
                this.log.warn("Error decoding attribute query message", (Throwable)e);
                requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, null, "Error decoding message"));
                throw new ProfileException("Error decoding attribute query message", (Exception)((Object)e));
            }
            catch (SecurityException e) {
                this.log.warn("Message did not meet security requirements", (Throwable)e);
                requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, StatusCode.REQUEST_DENIED, "Message did not meet security requirements"));
                throw new ProfileException("Message did not meet security policy requirements", (Exception)((Object)e));
            }
        }
        finally {
            this.populateRequestContext(requestContext);
        }
    }

    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol"));
        }
    }

    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:1.1:protocol"));
        }
    }

    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        Request request = (Request)requestContext.getInboundSAMLMessage();
        if (request == null) {
            this.log.error("Decoder did not contain an attribute query, an error occured decoding the message");
            throw new ProfileException("Unable to decode message.");
        }
        AttributeQuery query = request.getAttributeQuery();
        if (query != null) {
            Subject subject = query.getSubject();
            if (subject == null) {
                this.log.error("Attribute query did not contain a proper subject");
                ((AttributeQueryContext)requestContext).setFailureStatus(this.buildStatus(StatusCode.REQUESTER, null, "Attribute query did not contain a proper subject"));
                throw new ProfileException("Attribute query did not contain a proper subject");
            }
            requestContext.setSubjectNameIdentifier((SAMLObject)subject.getNameIdentifier());
        }
    }

    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) {
        Endpoint endpoint;
        if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding")) {
            endpoint = (Endpoint)this.acsEndpointBuilder.buildObject();
            endpoint.setBinding("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        } else {
            BasicEndpointSelector endpointSelector = new BasicEndpointSelector();
            endpointSelector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeQueryContext
    extends BaseSAML1ProfileRequestContext<Request, Response, AttributeQueryConfiguration> {
        protected AttributeQueryContext() {
        }
    }
}

