/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationEngine;
import edu.internet2.middleware.shibboleth.idp.authn.provider.AbstractLoginHandler;
import edu.internet2.middleware.shibboleth.idp.util.IPRange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressLoginHandler
extends AbstractLoginHandler {
    private final Logger log = LoggerFactory.getLogger(IPAddressLoginHandler.class);
    private String authenticatedUser;
    private List<IPRange> ipRanges;
    private boolean ipInRangeIsAuthenticated;

    public IPAddressLoginHandler(String user, List<IPRange> ranges, boolean ipInRangeIsAuthenticated) {
        this.authenticatedUser = DatatypeHelper.safeTrimOrNullString((String)user);
        if (this.authenticatedUser == null) {
            throw new IllegalArgumentException("The authenticated user ID may not be null or empty");
        }
        if (ranges == null || ranges.isEmpty()) {
            throw new IllegalArgumentException("The list of IP ranges may not be null or empty");
        }
        this.ipRanges = new ArrayList<IPRange>(ranges);
        this.ipInRangeIsAuthenticated = ipInRangeIsAuthenticated;
    }

    @Override
    public boolean supportsPassive() {
        return true;
    }

    @Override
    public boolean supportsForceAuthentication() {
        return true;
    }

    @Override
    public void login(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.log.debug("Attempting to authenticated client '{}'", (Object)httpRequest.getRemoteAddr());
        try {
            InetAddress clientAddress = InetAddress.getByName(httpRequest.getRemoteAddr());
            if (this.authenticate(clientAddress)) {
                this.log.debug("Authenticated user by IP address");
                httpRequest.setAttribute("principal_name", (Object)this.authenticatedUser);
            } else {
                this.log.debug("Client IP address {} failed authentication.", (Object)httpRequest.getRemoteAddr());
                httpRequest.setAttribute("authnError", (Object)"Client failed IP address authentication");
            }
        }
        catch (UnknownHostException e) {
            String msg = MessageFormatter.format((String)"Unable to resolve {} in to an IP address", (Object)httpRequest.getRemoteAddr());
            this.log.warn(msg);
            httpRequest.setAttribute("authnError", (Object)msg);
        }
        AuthenticationEngine.returnToAuthenticationEngine(httpRequest, httpResponse);
    }

    protected boolean authenticate(InetAddress clientAddress) {
        if (this.ipInRangeIsAuthenticated) {
            for (IPRange range : this.ipRanges) {
                if (!range.contains(clientAddress)) continue;
                return true;
            }
        } else {
            for (IPRange range : this.ipRanges) {
                if (range.contains(clientAddress)) continue;
                return true;
            }
        }
        return false;
    }
}

