/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn;

import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationException;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.opensaml.xml.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginContext
implements Serializable {
    public static final String LOGIN_CONTEXT_KEY = "shib2.logincontext";
    private static final long serialVersionUID = -8764003758734956911L;
    private String relyingPartyId;
    private boolean forceAuth;
    private boolean passiveAuth;
    private Map<String, Serializable> propsMap = new ConcurrentHashMap<String, Serializable>(0);
    private String profileHandlerURL;
    private String authnEngineURL;
    private boolean authnAttempted;
    private String attemptedAuthnMethod;
    private boolean principalAuthenticated;
    private AuthenticationException authnException;
    private String sessionID;
    private String defaultAuthenticationMethod;
    private List<String> requestAuthenticationMethods;
    private AuthenticationMethodInformation authenticationMethodInformation;

    public LoginContext() {
        this.requestAuthenticationMethods = new LazyList();
    }

    public LoginContext(boolean force, boolean passive) {
        this.forceAuth = force;
        this.passiveAuth = passive;
        this.requestAuthenticationMethods = new LazyList();
    }

    public synchronized String getAttemptedAuthnMethod() {
        return this.attemptedAuthnMethod;
    }

    public synchronized boolean getAuthenticationAttempted() {
        return this.authnAttempted;
    }

    public synchronized long getAuthenticationDuration() {
        return this.authenticationMethodInformation.getAuthenticationDuration();
    }

    public synchronized String getAuthenticationEngineURL() {
        return this.authnEngineURL;
    }

    public synchronized AuthenticationException getAuthenticationFailure() {
        return this.authnException;
    }

    public synchronized DateTime getAuthenticationInstant() {
        return this.authenticationMethodInformation.getAuthenticationInstant();
    }

    public synchronized String getAuthenticationMethod() {
        return this.authenticationMethodInformation.getAuthenticationMethod();
    }

    public synchronized AuthenticationMethodInformation getAuthenticationMethodInformation() {
        return this.authenticationMethodInformation;
    }

    public synchronized String getDefaultAuthenticationMethod() {
        return this.defaultAuthenticationMethod;
    }

    public synchronized String getPrincipalName() {
        return this.authenticationMethodInformation.getAuthenticationPrincipal().getName();
    }

    public synchronized String getProfileHandlerURL() {
        return this.profileHandlerURL;
    }

    public synchronized Object getProperty(String key) {
        return this.propsMap.get(key);
    }

    public synchronized String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    public synchronized List<String> getRequestedAuthenticationMethods() {
        return this.requestAuthenticationMethods;
    }

    public synchronized String getSessionID() {
        return this.sessionID;
    }

    public synchronized boolean isForceAuthRequired() {
        return this.forceAuth;
    }

    public synchronized boolean isPassiveAuthRequired() {
        return this.passiveAuth;
    }

    public synchronized boolean isPrincipalAuthenticated() {
        return this.principalAuthenticated;
    }

    public synchronized void setAttemptedAuthnMethod(String method) {
        this.attemptedAuthnMethod = method;
    }

    public synchronized void setAuthenticationAttempted() {
        this.authnAttempted = true;
    }

    public synchronized void setAuthenticationDuration(long duration) {
    }

    public synchronized void setAuthenticationEngineURL(String url) {
        this.authnEngineURL = url;
    }

    public synchronized void setAuthenticationFailure(AuthenticationException error) {
        this.authnException = error;
    }

    public synchronized void setAuthenticationInstant(DateTime instant) {
    }

    public synchronized void setAuthenticationMethod(String method) {
    }

    public synchronized void setAuthenticationMethodInformation(AuthenticationMethodInformation info) {
        this.authenticationMethodInformation = info;
    }

    public synchronized void setDefaultAuthenticationMethod(String method) {
        this.defaultAuthenticationMethod = method;
    }

    public synchronized void setForceAuthRequired(boolean force) {
        this.forceAuth = force;
    }

    public synchronized void setPassiveAuthRequired(boolean passive) {
        this.passiveAuth = passive;
    }

    public synchronized void setPrincipalAuthenticated(boolean authnOK) {
        this.principalAuthenticated = authnOK;
    }

    public synchronized void setPrincipalName(String id) {
    }

    public synchronized void setProfileHandlerURL(String url) {
        this.profileHandlerURL = url;
    }

    public synchronized void setProperty(String key, Serializable obj) {
        this.propsMap.put(key, obj);
    }

    public synchronized void setRelyingParty(String id) {
        this.relyingPartyId = id;
    }

    public synchronized void setSessionID(String id) {
        this.sessionID = id;
    }
}

