/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.util.Comparator;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.AbstractAttributeType;
import org.apache.directory.shared.ldap.schema.AbstractMatchingRule;
import org.apache.directory.shared.ldap.schema.AbstractSyntax;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.schema.normalizers.DeepTrimToLowerNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;

public class TestServerEntryUtils {
    static AttributeType getCaseIgnoringAttributeNoNumbersType() {
        S s = new S("1.1.1.1", true);
        s.setSyntaxChecker(new SyntaxChecker(){

            public String getSyntaxOid() {
                return "1.1.1.1";
            }

            public boolean isValidSyntax(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                String strval = (String)value;
                for (char c : strval.toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    return false;
                }
                return true;
            }

            public void assertSyntax(Object value) throws NamingException {
                if (!this.isValidSyntax(value)) {
                    throw new InvalidAttributeValueException();
                }
            }
        });
        MR mr = new MR("1.1.2.1");
        mr.syntax = s;
        mr.comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            }

            int getValue(String val) {
                if (val.equals("LOW")) {
                    return 0;
                }
                if (val.equals("MEDIUM")) {
                    return 1;
                }
                if (val.equals("HIGH")) {
                    return 2;
                }
                throw new IllegalArgumentException("Not a valid value");
            }
        };
        mr.normalizer = new Normalizer(){
            private static final long serialVersionUID = 1L;

            public Value<?> normalize(Value<?> value) throws NamingException {
                if (!value.isBinary()) {
                    return new ClientStringValue(value.getString().toLowerCase());
                }
                throw new IllegalStateException("expected string to normalize");
            }

            public String normalize(String value) throws NamingException {
                return value.toLowerCase();
            }
        };
        AT at = new AT("1.1.3.1");
        at.setEquality((MatchingRule)mr);
        at.setSyntax((Syntax)s);
        return at;
    }

    static AttributeType getIA5StringAttributeType() {
        AT at = new AT("1.1");
        S s = new S("1.1.1", true);
        s.setSyntaxChecker(new SyntaxChecker(){

            public String getSyntaxOid() {
                return "1.1.1";
            }

            public boolean isValidSyntax(Object value) {
                return (String)value == null || ((String)value).length() < 7;
            }

            public void assertSyntax(Object value) throws NamingException {
                if (!this.isValidSyntax(value)) {
                    throw new InvalidAttributeValueException();
                }
            }
        });
        MR mr = new MR("1.1.2");
        mr.syntax = s;
        mr.comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            }
        };
        mr.normalizer = new DeepTrimToLowerNormalizer();
        at.setEquality((MatchingRule)mr);
        at.setSyntax((Syntax)s);
        return at;
    }

    static AttributeType getBytesAttributeType() {
        AT at = new AT("1.2");
        S s = new S("1.2.1", true);
        s.setSyntaxChecker(new SyntaxChecker(){

            public String getSyntaxOid() {
                return "1.2.1";
            }

            public boolean isValidSyntax(Object value) {
                return value == null || ((byte[])value).length < 5;
            }

            public void assertSyntax(Object value) throws NamingException {
                if (!this.isValidSyntax(value)) {
                    throw new InvalidAttributeValueException();
                }
            }
        });
        MR mr = new MR("1.2.2");
        mr.syntax = s;
        mr.comparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : ByteArrayComparator.INSTANCE.compare(o1, o2));
            }
        };
        mr.normalizer = new Normalizer(){
            private static final long serialVersionUID = 1L;

            public Value<?> normalize(Value<?> value) throws NamingException {
                if (value.isBinary()) {
                    byte[] val = value.getBytes();
                    byte[] newVal = new byte[val.length];
                    int i = 0;
                    for (byte b : val) {
                        newVal[i++] = (byte)(b & 0x7F);
                    }
                    return new ClientBinaryValue(StringTools.trim((byte[])newVal));
                }
                throw new IllegalStateException("expected byte[] to normalize");
            }

            public String normalize(String value) throws NamingException {
                throw new IllegalStateException("expected byte[] to normalize");
            }
        };
        at.setEquality((MatchingRule)mr);
        at.setSyntax((Syntax)s);
        return at;
    }

    static class S
    extends AbstractSyntax {
        private static final long serialVersionUID = 0L;
        SyntaxChecker checker;

        public S(String oid, boolean humanReadible) {
            super(oid, humanReadible);
        }

        public void setSyntaxChecker(SyntaxChecker checker) {
            this.checker = checker;
        }

        public SyntaxChecker getSyntaxChecker() throws NamingException {
            return this.checker;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MR
    extends AbstractMatchingRule {
        private static final long serialVersionUID = 0L;
        Syntax syntax;
        Comparator comparator;
        Normalizer normalizer;

        protected MR(String oid) {
            super(oid);
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntax;
        }

        public Comparator getComparator() throws NamingException {
            return this.comparator;
        }

        public Normalizer getNormalizer() throws NamingException {
            return this.normalizer;
        }

        public void setSyntax(Syntax syntax) {
            this.syntax = syntax;
        }

        public void setComparator(Comparator<?> comparator) {
            this.comparator = comparator;
        }

        public void setNormalizer(Normalizer normalizer) {
            this.normalizer = normalizer;
        }
    }

    static class AT
    extends AbstractAttributeType {
        private static final long serialVersionUID = 0L;
        AttributeType superior;
        Syntax syntax;
        MatchingRule equality;
        MatchingRule ordering;
        MatchingRule substr;

        protected AT(String oid) {
            super(oid);
        }

        public AttributeType getSuperior() throws NamingException {
            return this.superior;
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntax;
        }

        public MatchingRule getEquality() throws NamingException {
            return this.equality;
        }

        public MatchingRule getOrdering() throws NamingException {
            return this.ordering;
        }

        public MatchingRule getSubstr() throws NamingException {
            return this.substr;
        }

        public void setSuperior(AttributeType superior) {
            this.superior = superior;
        }

        public void setSyntax(Syntax syntax) {
            this.syntax = syntax;
        }

        public void setEquality(MatchingRule equality) {
            this.equality = equality;
        }

        public void setOrdering(MatchingRule ordering) {
            this.ordering = ordering;
        }

        public void setSubstr(MatchingRule substr) {
            this.substr = substr;
        }
    }
}

