/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.AbstractEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.LdapDNSerializer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServerEntry
extends AbstractEntry<AttributeType>
implements ServerEntry {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerEntry.class);
    private final transient AttributeTypeRegistry atRegistry;
    private static transient AttributeType OBJECT_CLASS_AT;
    private static transient Object MUTEX;

    private AttributeType getAttributeType(String upId) throws NamingException {
        if (StringTools.isEmpty((String)StringTools.trim((String)upId))) {
            String message = "The ID should not be null or empty";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return this.atRegistry.lookup(upId);
    }

    public static String getUpId(String upId, AttributeType attributeType) {
        String normUpId = StringTools.trim((String)upId);
        if (attributeType == null) {
            if (StringTools.isEmpty((String)normUpId)) {
                String message = "Cannot add an attribute without an ID";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (StringTools.isEmpty((String)normUpId) && StringTools.isEmpty((String)(upId = attributeType.getName()))) {
            upId = attributeType.getOid();
        }
        return upId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObjectClassAT(Registries registries) {
        block5: {
            try {
                if (OBJECT_CLASS_AT != null) break block5;
                Object object = MUTEX;
                synchronized (object) {
                    OBJECT_CLASS_AT = this.atRegistry.lookup("objectClass");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void createAttribute(String upId, AttributeType attributeType, byte[] ... values) {
        DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType, attribute);
    }

    private void createAttribute(String upId, AttributeType attributeType, String ... values) {
        DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType, attribute);
    }

    private void createAttribute(String upId, AttributeType attributeType, Value<?> ... values) {
        DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType, attribute);
    }

    DefaultServerEntry() {
        this.atRegistry = null;
        this.dn = LdapDN.EMPTY_LDAPDN;
    }

    public DefaultServerEntry(Registries registries) {
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.dn = LdapDN.EMPTY_LDAPDN;
        this.initObjectClassAT(registries);
    }

    public DefaultServerEntry(Registries registries, Entry entry) {
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.initObjectClassAT(registries);
        this.dn = entry.getDn() != null ? (LdapDN)entry.getDn().clone() : LdapDN.EMPTY_LDAPDN;
        if (!this.dn.isNormalized()) {
            try {
                this.dn.normalize(registries.getAttributeTypeRegistry().getNormalizerMapping());
            }
            catch (NamingException ne) {
                LOG.warn("The DN '" + entry.getDn() + "' cannot be normalized");
            }
        }
        this.attributes = new HashMap(entry.size());
        for (EntryAttribute attribute : entry) {
            try {
                AttributeType attributeType = null;
                attributeType = attribute instanceof ServerAttribute ? ((ServerAttribute)attribute).getAttributeType() : registries.getAttributeTypeRegistry().lookup(attribute.getId());
                DefaultServerAttribute serverAttribute = new DefaultServerAttribute(attributeType, attribute);
                this.add(new EntryAttribute[]{serverAttribute});
            }
            catch (NamingException ne) {
                LOG.warn("The attribute '" + attribute.getId() + "' cannot be stored");
            }
        }
    }

    public DefaultServerEntry(Registries registries, LdapDN dn) {
        if (dn == null) {
            dn = LdapDN.EMPTY_LDAPDN;
        } else {
            this.dn = dn;
        }
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.initObjectClassAT(registries);
    }

    public DefaultServerEntry(Registries registries, LdapDN dn, AttributeType ... attributeTypes) {
        if (dn == null) {
            dn = LdapDN.EMPTY_LDAPDN;
        } else {
            this.dn = dn;
        }
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.initObjectClassAT(registries);
        this.set(attributeTypes);
    }

    public DefaultServerEntry(Registries registries, LdapDN dn, AttributeType attributeType, String upId) {
        if (dn == null) {
            dn = LdapDN.EMPTY_LDAPDN;
        } else {
            this.dn = dn;
        }
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.initObjectClassAT(registries);
        try {
            this.put(upId, attributeType, new String[]{null});
        }
        catch (NamingException ne) {
            LOG.error("We have had an error while adding the '{}' AttributeType : {}", (Object)upId, (Object)ne.getMessage());
        }
    }

    public DefaultServerEntry(Registries registries, LdapDN dn, String ... upIds) {
        if (dn == null) {
            dn = LdapDN.EMPTY_LDAPDN;
        } else {
            this.dn = dn;
        }
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.initObjectClassAT(registries);
        this.set(upIds);
    }

    public DefaultServerEntry(Registries registries, LdapDN dn, ServerAttribute ... attributes) {
        if (dn == null) {
            dn = LdapDN.EMPTY_LDAPDN;
        } else {
            this.dn = dn;
        }
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.initObjectClassAT(registries);
        for (ServerAttribute attribute : attributes) {
            try {
                this.put(new EntryAttribute[]{attribute});
            }
            catch (NamingException ne) {
                LOG.warn("The ServerAttribute '{}' does not exist. It has been discarded", (Object)attribute);
            }
        }
    }

    @Override
    public void add(AttributeType attributeType, byte[] ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (attributeType.equals(OBJECT_CLASS_AT)) {
            String message = "Only String values supported for objectClass attribute";
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, String ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, Value<?> ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    public void add(EntryAttribute ... attributes) throws NamingException {
        for (EntryAttribute attribute : attributes) {
            ServerAttribute serverAttribute = (ServerAttribute)attribute;
            AttributeType attributeType = serverAttribute.getAttributeType();
            if (this.attributes.containsKey(attributeType)) {
                EntryAttribute oldAttribute = (EntryAttribute)this.attributes.get(attributeType);
                Iterator i$ = serverAttribute.iterator();
                while (i$.hasNext()) {
                    Value value = (Value)i$.next();
                    oldAttribute.add(new Value[]{value});
                }
                oldAttribute.setUpId(serverAttribute.getUpId());
                continue;
            }
            this.attributes.put(attributeType, attribute);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        if (attributeType.equals(OBJECT_CLASS_AT)) {
            String message = "Only String values supported for objectClass attribute";
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        ServerAttribute attribute = (ServerAttribute)this.attributes.get(attributeType);
        upId = DefaultServerEntry.getUpId(upId, attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        upId = DefaultServerEntry.getUpId(upId, attributeType);
        ServerAttribute attribute = (ServerAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, String ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        upId = DefaultServerEntry.getUpId(upId, attributeType);
        ServerAttribute attribute = (ServerAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    public void add(String upId, byte[] ... values) throws NamingException {
        this.add(upId, this.getAttributeType(upId), values);
    }

    public void add(String upId, String ... values) throws NamingException {
        this.add(upId, this.getAttributeType(upId), values);
    }

    public void add(String upId, Value<?> ... values) throws NamingException {
        this.add(upId, this.getAttributeType(upId), values);
    }

    @Override
    public boolean contains(AttributeType attributeType, byte[] ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, String ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    public boolean contains(EntryAttribute ... attributes) throws NamingException {
        for (EntryAttribute entryAttribute : attributes) {
            if (entryAttribute == null) {
                return this.attributes.size() == 0;
            }
            if (this.attributes.containsKey(((ServerAttribute)entryAttribute).getAttributeType())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String id, byte[] ... values) {
        if (id == null) {
            return false;
        }
        try {
            AttributeType attributeType = this.atRegistry.lookup(id);
            if (attributeType == null) {
                return false;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute != null) {
                return attribute.contains(values);
            }
            return false;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    public boolean contains(String id, String ... values) {
        if (id == null) {
            return false;
        }
        try {
            AttributeType attributeType = this.atRegistry.lookup(id);
            if (attributeType == null) {
                return false;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute != null) {
                return attribute.contains(values);
            }
            return false;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    public boolean contains(String id, Value<?> ... values) {
        if (id == null) {
            return false;
        }
        try {
            AttributeType attributeType = this.atRegistry.lookup(id);
            if (attributeType == null) {
                return false;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute != null) {
                return attribute.contains(values);
            }
            return false;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    @Override
    public boolean containsAttribute(AttributeType attributeType) {
        return this.attributes.containsKey(attributeType);
    }

    public boolean containsAttribute(String ... attributes) {
        for (String attribute : attributes) {
            try {
                if (this.attributes.containsKey(this.getAttributeType(attribute))) continue;
                return false;
            }
            catch (NamingException ne) {
                return false;
            }
        }
        return true;
    }

    @Override
    public EntryAttribute get(AttributeType attributeType) {
        return (EntryAttribute)this.attributes.get(attributeType);
    }

    public EntryAttribute get(String alias) {
        try {
            return this.get(this.atRegistry.lookup(alias));
        }
        catch (NamingException ne) {
            String message = ne.getMessage();
            LOG.error(message);
            return null;
        }
    }

    @Override
    public Set<AttributeType> getAttributeTypes() {
        return this.attributes.keySet();
    }

    public boolean hasObjectClass(String objectClass) {
        return this.contains(OBJECT_CLASS_AT, objectClass);
    }

    @Override
    public boolean hasObjectClass(EntryAttribute objectClass) {
        if (objectClass == null) {
            return false;
        }
        if (!((ServerAttribute)objectClass).getAttributeType().equals(OBJECT_CLASS_AT)) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(OBJECT_CLASS_AT);
        if (attribute == null) {
            return false;
        }
        for (Value value : objectClass) {
            if (attribute.contains(new String[]{value.getString()})) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isValid(EntryAttribute objectClass) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isValid(String objectClass) {
        throw new NotImplementedException();
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws NamingException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, String ... values) throws NamingException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws NamingException {
        return this.put(null, attributeType, values);
    }

    public List<EntryAttribute> put(EntryAttribute ... attributes) throws NamingException {
        ArrayList<EntryAttribute> previous = new ArrayList<EntryAttribute>();
        for (EntryAttribute serverAttribute : attributes) {
            if (serverAttribute == null) {
                String message = "The ServerAttribute list should not contain null elements";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            EntryAttribute removed = this.attributes.put(((ServerAttribute)serverAttribute).getAttributeType(), serverAttribute);
            if (removed == null) continue;
            previous.add(removed);
        }
        return previous;
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!StringTools.isEmpty((String)upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = "The '" + upId + "' id is not compatible with the '" + attributeType + "' attribute type";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultServerEntry.getUpId(upId, attributeType);
        }
        if (attributeType.equals(OBJECT_CLASS_AT)) {
            String message = "Only String values supported for objectClass attribute";
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(upId, attributeType, values);
        return (EntryAttribute)this.attributes.put(attributeType, attribute);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws NamingException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (IllegalArgumentException iae) {
                String message = "The attributeType should not be null";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!StringTools.isEmpty((String)upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = "The '" + upId + "' id is not compatible with the '" + attributeType + "' attribute type";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultServerEntry.getUpId(upId, attributeType);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(upId, attributeType, values);
        return (EntryAttribute)this.attributes.put(attributeType, attribute);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        if (attributeType == null) {
            String message = "The attributeType should not be null";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!StringTools.isEmpty((String)upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = "The '" + upId + "' id is not compatible with the '" + attributeType + "' attribute type";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultServerEntry.getUpId(upId, attributeType);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(upId, attributeType, values);
        return (EntryAttribute)this.attributes.put(attributeType, attribute);
    }

    public EntryAttribute put(String upId, byte[] ... values) {
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (NamingException ne) {
            String message = "Error while adding values into the '" + upId + "' attribute. Error : " + ne.getMessage();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    public EntryAttribute put(String upId, String ... values) {
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (NamingException ne) {
            String message = "Error while adding values into the '" + upId + "' attribute. Error : " + ne.getMessage();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    public EntryAttribute put(String upId, Value<?> ... values) {
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (NamingException ne) {
            String message = "Error while adding values into the '" + upId + "' attribute. Error : " + ne.getMessage();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, byte[] ... values) throws NamingException {
        try {
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The removal of values for the missing '{}' attribute is not possible", (Object)attributeType);
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, String ... values) throws NamingException {
        try {
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The removal of values for the missing '{}' attribute is not possible", (Object)attributeType);
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, Value<?> ... values) throws NamingException {
        try {
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The removal of values for the missing '{}' attribute is not possible", (Object)attributeType);
            return false;
        }
    }

    @Override
    public List<EntryAttribute> remove(EntryAttribute ... attributes) throws NamingException {
        ArrayList<EntryAttribute> removedAttributes = new ArrayList<EntryAttribute>();
        for (EntryAttribute serverAttribute : attributes) {
            if (!this.attributes.containsKey(((ServerAttribute)serverAttribute).getAttributeType())) continue;
            this.attributes.remove(((ServerAttribute)serverAttribute).getAttributeType());
            removedAttributes.add(serverAttribute);
        }
        return removedAttributes;
    }

    public boolean remove(String upId, byte[] ... values) throws NamingException {
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (NamingException ne) {
            LOG.error("The removal of values for the missing '{}' attribute is not possible", (Object)upId);
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The removal of values for the bad '{}' attribute is not possible", (Object)upId);
            return false;
        }
    }

    public boolean remove(String upId, String ... values) throws NamingException {
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (NamingException ne) {
            LOG.error("The removal of values for the missing '{}' attribute is not possible", (Object)upId);
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The removal of values for the bad '{}' attribute is not possible", (Object)upId);
            return false;
        }
    }

    public boolean remove(String upId, Value<?> ... values) throws NamingException {
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (NamingException ne) {
            LOG.error("The removal of values for the missing '{}' attribute is not possible", (Object)upId);
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The removal of values for the bad '{}' attribute is not possible", (Object)upId);
            return false;
        }
    }

    @Override
    public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
        if (attributes.length == 0) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        for (AttributeType attributeType : attributes) {
            EntryAttribute attr = (EntryAttribute)this.attributes.remove(attributeType);
            if (attr == null) continue;
            removed.add(attr);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    public List<EntryAttribute> removeAttributes(String ... attributes) {
        if (attributes.length == 0) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        for (String attribute : attributes) {
            AttributeType attributeType = null;
            try {
                attributeType = this.atRegistry.lookup(attribute);
            }
            catch (NamingException ne) {
                String message = "The attribute '" + attribute + "' does not exist in the entry";
                LOG.warn(message);
                continue;
            }
            EntryAttribute attr = (EntryAttribute)this.attributes.remove(attributeType);
            if (attr == null) continue;
            removed.add(attr);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> set(AttributeType ... attributeTypes) {
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>();
        for (AttributeType attributeType : attributeTypes) {
            if (attributeType == null) {
                String message = "The AttributeType list should not contain null values";
                LOG.error(message);
                continue;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.put(attributeType, new DefaultServerAttribute(attributeType));
            if (attribute == null) continue;
            removed.add(attribute);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    public List<EntryAttribute> set(String ... upIds) {
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>();
        for (String upId : upIds) {
            AttributeType attributeType = null;
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (NamingException ne) {
                LOG.warn("Trying to add a bad attribute type '{}', error : ", (Object)upId, (Object)ne.getMessage());
                continue;
            }
            catch (IllegalArgumentException iae) {
                LOG.warn("Trying to add a bad attribute type '{}', error : ", (Object)upId, (Object)iae.getMessage());
                continue;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.put(attributeType, new DefaultServerAttribute(upId, attributeType));
            if (attribute == null) continue;
            removed.add(attribute);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public Entry toClientEntry() throws NamingException {
        DefaultClientEntry clientEntry = new DefaultClientEntry(this.dn);
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            EntryAttribute serverAttribute = (EntryAttribute)i$.next();
            EntryAttribute clientAttribute = ((ServerAttribute)serverAttribute).toClientAttribute();
            clientEntry.add(new EntryAttribute[]{clientAttribute});
        }
        return clientEntry;
    }

    @Override
    public Entry clone() {
        DefaultServerEntry clone = (DefaultServerEntry)super.clone();
        if (this.dn != null) {
            clone.dn = (LdapDN)this.dn.clone();
        }
        clone.attributes = (Map)((HashMap)this.attributes).clone();
        clone.attributes.clear();
        for (AttributeType key : this.attributes.keySet()) {
            ServerAttribute value = (ServerAttribute)((EntryAttribute)this.attributes.get(key)).clone();
            clone.attributes.put(key, value);
        }
        return clone;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException("Cannot use standard serialization for a ServerEntry");
    }

    public void serialize(ObjectOutput out) throws IOException {
        LdapDNSerializer.serialize((LdapDN)this.dn, (ObjectOutput)out);
        out.writeInt(this.attributes.size());
        for (AttributeType attributeType : this.attributes.keySet()) {
            String oid = attributeType.getOid();
            out.writeUTF(oid);
            DefaultServerAttribute attribute = (DefaultServerAttribute)this.attributes.get(attributeType);
            attribute.serialize(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException("Cannot use standard serialization for a ServerAttribute");
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dn = LdapDNSerializer.deserialize((ObjectInput)in);
        int nbAttributes = in.readInt();
        for (int i = 0; i < nbAttributes; ++i) {
            String oid = in.readUTF();
            try {
                AttributeType attributeType = this.atRegistry.lookup(oid);
                DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType);
                attribute.deserialize(in);
                this.attributes.put(attributeType, attribute);
                continue;
            }
            catch (NamingException ne) {
                LOG.warn("Cannot read the attribute as it's OID ('" + oid + "') does not exist");
            }
        }
    }

    public int hashCode() {
        int result = 37;
        result = result * 17 + this.dn.hashCode();
        for (EntryAttribute attribute : this.attributes.values()) {
            result = result * 17 + attribute.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultServerEntry)) {
            return false;
        }
        DefaultServerEntry other = (DefaultServerEntry)o;
        if (this.dn == null ? other.getDn() != null : !this.dn.equals((Object)other.getDn())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator i$ = other.iterator();
        while (i$.hasNext()) {
            EntryAttribute attribute = (EntryAttribute)i$.next();
            EntryAttribute attr = (EntryAttribute)this.attributes.get(((ServerAttribute)attribute).getAttributeType());
            if (attr == null) {
                return false;
            }
            if (attribute.equals(attr)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerEntry\n");
        sb.append("    dn");
        if (this.dn.isNormalized()) {
            sb.append("[n]: ");
            sb.append(this.dn.getUpName());
        } else {
            sb.append("[]: ");
            sb.append(this.dn);
        }
        sb.append('\n');
        if (this.containsAttribute(OBJECT_CLASS_AT)) {
            EntryAttribute objectClass = this.get(OBJECT_CLASS_AT);
            sb.append(objectClass);
        }
        if (this.attributes.size() != 0) {
            for (EntryAttribute attribute : this.attributes.values()) {
                if (((ServerAttribute)attribute).getAttributeType().equals(OBJECT_CLASS_AT)) continue;
                sb.append(attribute);
            }
        }
        return sb.toString();
    }

    static {
        MUTEX = new Object();
    }
}

