/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifRevertor {
    public static final boolean DELETE_OLD_RDN = true;
    public static final boolean KEEP_OLD_RDN = false;

    public static LdifEntry reverseAdd(LdapDN dn) {
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Delete);
        entry.setDn(dn);
        return entry;
    }

    public static LdifEntry reverseDel(LdapDN dn, Entry deletedEntry) throws NamingException {
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn);
        entry.setChangeType(ChangeType.Add);
        for (EntryAttribute attribute : deletedEntry) {
            entry.addAttribute(attribute);
        }
        return entry;
    }

    public static LdifEntry reverseModify(LdapDN dn, List<Modification> forwardModifications, Entry modifiedEntry) throws NamingException {
        Entry clonedEntry = modifiedEntry.clone();
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Modify);
        entry.setDn(dn);
        ArrayList<ClientModification> reverseModifications = new ArrayList<ClientModification>();
        block5: for (Modification modification : forwardModifications) {
            switch (modification.getOperation()) {
                case ADD_ATTRIBUTE: {
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = clonedEntry.get(mod.getId());
                    if (mod.equals(previous)) continue block5;
                    ClientModification reverseModification = new ClientModification(ModificationOperation.REMOVE_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    ClientModification reverseModification;
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = clonedEntry.get(mod.getId());
                    if (previous == null) continue block5;
                    if (mod.get() == null) {
                        reverseModification = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        break;
                    }
                    reverseModification = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    ClientModification reverseModification;
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = clonedEntry.get(mod.getId());
                    if (mod.get() == null && previous == null) {
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)new DefaultClientAttribute(mod.getId()));
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (mod.get() == null) {
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (previous == null) {
                        DefaultClientAttribute emptyAttribute = new DefaultClientAttribute(mod.getId());
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)emptyAttribute);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
            }
            AttributeUtils.applyModification(clonedEntry, modification);
        }
        if (reverseModifications.size() == 0) {
            throw new IllegalArgumentException("Could not deduce reverse modifications from provided modifications: " + forwardModifications);
        }
        for (Modification modification : reverseModifications) {
            entry.addModificationItem(modification);
        }
        return entry;
    }

    public static LdifEntry reverseMove(LdapDN newSuperiorDn, LdapDN modifiedDn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        LdapDN currentParent = null;
        Rdn currentRdn = null;
        LdapDN newDn = null;
        if (newSuperiorDn == null) {
            throw new NullPointerException("newSuperiorDn must not be null");
        }
        if (modifiedDn == null) {
            throw new NullPointerException("modifiedDn must not be null");
        }
        if (modifiedDn.size() == 0) {
            throw new IllegalArgumentException("Don't think about moving the rootDSE.");
        }
        currentParent = (LdapDN)modifiedDn.clone();
        currentRdn = currentParent.getRdn();
        currentParent.remove(currentParent.size() - 1);
        newDn = (LdapDN)newSuperiorDn.clone();
        newDn.add(modifiedDn.getRdn());
        entry.setChangeType(ChangeType.ModDn);
        entry.setDn(newDn);
        entry.setNewRdn(currentRdn.getUpName());
        entry.setNewSuperior(currentParent.getUpName());
        entry.setDeleteOldRdn(false);
        return entry;
    }

    private static LdifEntry revertEntry(List<LdifEntry> entries, Entry entry, LdapDN newDn, LdapDN newSuperior, Rdn oldRdn, Rdn newRdn) throws InvalidNameException {
        LdifEntry reverted = new LdifEntry();
        reverted.setChangeType(ChangeType.ModRdn);
        if (newSuperior != null) {
            LdapDN restoredDn = (LdapDN)((LdapDN)newSuperior.clone()).add(newRdn);
            reverted.setDn(restoredDn);
        } else {
            reverted.setDn(newDn);
        }
        reverted.setNewRdn(oldRdn.getUpName());
        boolean keepOldRdn = entry.contains(newRdn.getNormType(), newRdn.getNormValue());
        reverted.setDeleteOldRdn(!keepOldRdn);
        if (newSuperior != null) {
            LdapDN oldSuperior = (LdapDN)entry.getDn().clone();
            oldSuperior.remove(oldSuperior.size() - 1);
            reverted.setNewSuperior(oldSuperior.getUpName());
        }
        return reverted;
    }

    private static LdifEntry generateModify(LdapDN parentDn, Entry entry, Rdn oldRdn, Rdn newRdn) {
        LdifEntry restored = new LdifEntry();
        restored.setChangeType(ChangeType.Modify);
        restored.setDn(parentDn);
        for (AttributeTypeAndValue ava : newRdn) {
            if (entry.contains(ava.getNormType(), ava.getNormValue().getString()) || ava.getNormType().equals(oldRdn.getNormType()) && ava.getNormValue().equals(oldRdn.getNormValue())) continue;
            ClientModification modification = new ClientModification(ModificationOperation.REMOVE_ATTRIBUTE, (EntryAttribute)new DefaultClientAttribute(ava.getUpType(), ava.getUpValue().getString()));
            restored.addModificationItem(modification);
        }
        return restored;
    }

    private static LdifEntry generateReverted(LdapDN newSuperior, Rdn newRdn, LdapDN newDn, Rdn oldRdn, boolean deleteOldRdn) throws InvalidNameException {
        LdifEntry reverted = new LdifEntry();
        reverted.setChangeType(ChangeType.ModRdn);
        if (newSuperior != null) {
            LdapDN restoredDn = (LdapDN)((LdapDN)newSuperior.clone()).add(newRdn);
            reverted.setDn(restoredDn);
        } else {
            reverted.setDn(newDn);
        }
        reverted.setNewRdn(oldRdn.getUpName());
        if (newSuperior != null) {
            LdapDN oldSuperior = (LdapDN)newDn.clone();
            oldSuperior.remove(oldSuperior.size() - 1);
            reverted.setNewSuperior(oldSuperior.getUpName());
        }
        reverted.setDeleteOldRdn(deleteOldRdn);
        return reverted;
    }

    public static List<LdifEntry> reverseRename(Entry entry, Rdn newRdn, boolean deleteOldRdn) throws NamingException {
        return LdifRevertor.reverseMoveAndRename(entry, null, newRdn, deleteOldRdn);
    }

    public static List<LdifEntry> reverseMoveAndRename(Entry entry, LdapDN newSuperior, Rdn newRdn, boolean deleteOldRdn) throws NamingException {
        LdapDN parentDn = entry.getDn();
        LdapDN newDn = null;
        if (newRdn == null) {
            throw new NullPointerException("The newRdn must not be null");
        }
        if (parentDn == null) {
            throw new NullPointerException("The modified Dn must not be null");
        }
        if (parentDn.size() == 0) {
            throw new IllegalArgumentException("Don't think about renaming the rootDSE.");
        }
        parentDn = (LdapDN)entry.getDn().clone();
        Rdn oldRdn = parentDn.getRdn();
        newDn = (LdapDN)parentDn.clone();
        newDn.remove(newDn.size() - 1);
        newDn.add(newRdn);
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>(1);
        LdifEntry reverted = new LdifEntry();
        if (newRdn.size() == 1) {
            if (oldRdn.size() == 1 && oldRdn.equals(newRdn)) {
                throw new NamingException("Can't rename an entry using the same name ...");
            }
            reverted = LdifRevertor.revertEntry(entries, entry, newDn, newSuperior, oldRdn, newRdn);
            entries.add(reverted);
        } else if (oldRdn.size() == 1) {
            LdifEntry restored;
            boolean overlapping = false;
            boolean existInEntry = false;
            for (AttributeTypeAndValue atav : newRdn) {
                if (atav.equals(oldRdn.getAtav())) {
                    overlapping = true;
                    continue;
                }
                if (!entry.contains(atav.getNormType(), atav.getNormValue().getString())) continue;
                existInEntry = true;
            }
            if (overlapping) {
                if (existInEntry) {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                    entries.add(reverted);
                    restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                    entries.add(restored);
                } else {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                    entries.add(reverted);
                }
            } else if (existInEntry) {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                entries.add(reverted);
                restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                entries.add(restored);
            } else {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                entries.add(reverted);
            }
        } else {
            boolean overlapping = false;
            boolean existInEntry = false;
            HashSet<AttributeTypeAndValue> oldAtavs = new HashSet<AttributeTypeAndValue>();
            for (AttributeTypeAndValue atav : oldRdn) {
                oldAtavs.add(atav);
            }
            for (AttributeTypeAndValue atav : newRdn) {
                if (oldAtavs.contains(atav)) {
                    overlapping = true;
                    continue;
                }
                if (!entry.contains(atav.getNormType(), atav.getNormValue().getString())) continue;
                existInEntry = true;
            }
            if (overlapping) {
                if (existInEntry) {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                    entries.add(reverted);
                } else {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                    entries.add(reverted);
                }
            } else if (existInEntry) {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                entries.add(reverted);
                LdifEntry restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                entries.add(restored);
            } else {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                entries.add(reverted);
            }
        }
        return entries;
    }
}

