/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.ClientAttribute;

public class ClientModification
implements Modification {
    private ModificationOperation operation;
    private EntryAttribute attribute;

    public ClientModification(ModificationOperation operation, EntryAttribute attribute) {
        this.operation = operation;
        this.attribute = attribute;
    }

    public ClientModification() {
    }

    public ClientModification(int operation, EntryAttribute attribute) {
        this.setOperation(operation);
        this.attribute = attribute;
    }

    public ModificationOperation getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        switch (operation) {
            case 1: {
                this.operation = ModificationOperation.ADD_ATTRIBUTE;
                break;
            }
            case 2: {
                this.operation = ModificationOperation.REPLACE_ATTRIBUTE;
                break;
            }
            case 3: {
                this.operation = ModificationOperation.REMOVE_ATTRIBUTE;
            }
        }
    }

    public void setOperation(ModificationOperation operation) {
        this.operation = operation;
    }

    public EntryAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(EntryAttribute attribute) {
        this.attribute = (ClientAttribute)attribute;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientModification)) {
            return false;
        }
        ClientModification otherModification = (ClientModification)o;
        if (!this.operation.equals((Object)otherModification.getOperation())) {
            return false;
        }
        if (this.attribute == null) {
            return otherModification.getAttribute() == null;
        }
        return this.attribute.equals(otherModification.getAttribute());
    }

    public int hashCode() {
        int h = 37;
        h += h * 17 + this.operation.getValue();
        h += h * 17 + this.attribute.hashCode();
        return h;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int op = in.readInt();
        this.operation = ModificationOperation.getOperation(op);
        this.attribute = (ClientAttribute)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.operation.getValue());
        out.writeObject(this.attribute);
        out.flush();
    }

    public ClientModification clone() {
        try {
            ClientModification clone = (ClientModification)super.clone();
            clone.attribute = (ClientAttribute)this.attribute.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Modification: ").append((Object)this.operation).append("\n").append(", attribute : ").append(this.attribute);
        return sb.toString();
    }
}

