/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientBinaryValue
extends AbstractValue<byte[]> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientBinaryValue.class);

    public ClientBinaryValue() {
        this.wrapped = null;
        this.normalized = false;
        this.valid = null;
        this.normalizedValue = null;
    }

    public ClientBinaryValue(byte[] wrapped) {
        if (wrapped != null) {
            this.wrapped = new byte[wrapped.length];
            System.arraycopy(wrapped, 0, this.wrapped, 0, wrapped.length);
        } else {
            this.wrapped = null;
        }
        this.normalized = false;
        this.valid = null;
        this.normalizedValue = null;
    }

    @Override
    public void clear() {
        this.wrapped = null;
        this.normalized = false;
        this.normalizedValue = null;
        this.valid = null;
    }

    @Override
    public final void set(byte[] wrapped) {
        byte[] value = (byte[])this.getReference();
        if (value != null && Arrays.equals(wrapped, value)) {
            return;
        }
        this.normalizedValue = null;
        this.normalized = false;
        this.valid = null;
        if (wrapped == null) {
            this.wrapped = null;
        } else {
            this.wrapped = new byte[wrapped.length];
            System.arraycopy(wrapped, 0, this.wrapped, 0, wrapped.length);
        }
    }

    @Override
    public byte[] getNormalizedValueCopy() {
        if (this.normalizedValue == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])this.normalizedValue).length];
        System.arraycopy(this.normalizedValue, 0, copy, 0, ((byte[])this.normalizedValue).length);
        return copy;
    }

    @Override
    public final void normalize(Normalizer normalizer) throws NamingException {
        if (normalizer != null) {
            if (this.wrapped == null) {
                this.normalizedValue = this.wrapped;
                this.normalized = true;
                this.same = true;
            } else {
                this.normalizedValue = normalizer.normalize(this).getBytes();
                this.normalized = true;
                this.same = Arrays.equals((byte[])this.wrapped, (byte[])this.normalizedValue);
            }
        }
    }

    @Override
    public int compareTo(Value<byte[]> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (value instanceof ClientBinaryValue) {
            ClientBinaryValue binaryValue = (ClientBinaryValue)value;
            return ByteArrayComparator.INSTANCE.compare((byte[])this.getNormalizedValue(), (byte[])binaryValue.getNormalizedValue());
        }
        String message = "I don't really know how to compare anything other than ServerBinaryValues at this point in time.";
        LOG.error(message);
        throw new NotImplementedException(message);
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return Arrays.hashCode((byte[])this.getNormalizedValueReference());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientBinaryValue)) {
            return false;
        }
        ClientBinaryValue other = (ClientBinaryValue)obj;
        if (this.isNull()) {
            return other.isNull();
        }
        return Arrays.equals((byte[])this.getNormalizedValueReference(), (byte[])other.getNormalizedValueReference());
    }

    @Override
    public ClientBinaryValue clone() {
        ClientBinaryValue clone = (ClientBinaryValue)super.clone();
        if (this.normalizedValue != null) {
            clone.normalizedValue = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, clone.normalizedValue, 0, ((byte[])this.normalizedValue).length);
        }
        if (this.wrapped != null) {
            clone.wrapped = new byte[((byte[])this.wrapped).length];
            System.arraycopy(this.wrapped, 0, clone.wrapped, 0, ((byte[])this.wrapped).length);
        }
        return clone;
    }

    @Override
    public byte[] getCopy() {
        if (this.wrapped == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])this.wrapped).length];
        System.arraycopy(this.wrapped, 0, copy, 0, ((byte[])this.wrapped).length);
        return copy;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int length() {
        return this.wrapped != null ? ((byte[])this.wrapped).length : 0;
    }

    @Override
    public byte[] getBytes() {
        return this.getCopy();
    }

    @Override
    public String getString() {
        return StringTools.utf8ToString((byte[])this.wrapped);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int normalizedLength;
        int wrappedLength = in.readInt();
        if (wrappedLength >= 0) {
            this.wrapped = new byte[wrappedLength];
            if (wrappedLength > 0) {
                in.read((byte[])this.wrapped);
            }
        }
        this.normalized = in.readBoolean();
        if (this.normalized && (normalizedLength = in.readInt()) >= 0) {
            this.normalizedValue = new byte[normalizedLength];
            if (normalizedLength > 0) {
                in.read((byte[])this.normalizedValue);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.wrapped != null) {
            out.writeInt(((byte[])this.wrapped).length);
            if (((byte[])this.wrapped).length > 0) {
                out.write((byte[])this.wrapped, 0, ((byte[])this.wrapped).length);
            }
        } else {
            out.writeInt(-1);
        }
        if (this.normalized) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeInt(((byte[])this.normalizedValue).length);
                if (((byte[])this.normalizedValue).length > 0) {
                    out.write((byte[])this.normalizedValue, 0, ((byte[])this.normalizedValue).length);
                }
            } else {
                out.writeInt(-1);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public String toString() {
        if (this.wrapped == null) {
            return "null";
        }
        if (((byte[])this.wrapped).length > 16) {
            byte[] copy = new byte[16];
            System.arraycopy(this.wrapped, 0, copy, 0, 16);
            return "'" + StringTools.dumpBytes(copy) + "...'";
        }
        return "'" + StringTools.dumpBytes((byte[])this.wrapped) + "'";
    }
}

