/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modifyDn;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;

public class ModifyDNRequestCodec
extends LdapMessageCodec {
    private LdapDN entry;
    private Rdn newRDN;
    private boolean deleteOldRDN;
    private LdapDN newSuperior;
    private int modifyDNRequestLength;

    public int getMessageType() {
        return 11;
    }

    public LdapDN getEntry() {
        return this.entry;
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public boolean isDeleteOldRDN() {
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
    }

    public Rdn getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(Rdn newRDN) {
        this.newRDN = newRDN;
    }

    public LdapDN getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(LdapDN newSuperior) {
        this.newSuperior = newSuperior;
    }

    public int computeLength() {
        int newRdnlength = StringTools.getBytesUtf8(this.newRDN.toString()).length;
        this.modifyDNRequestLength = 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.entry)) + LdapDN.getNbBytes(this.entry) + 1 + TLV.getNbBytes((int)newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.newSuperior != null) {
            this.modifyDNRequestLength += 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.newSuperior)) + LdapDN.getNbBytes(this.newSuperior);
        }
        return 1 + TLV.getNbBytes((int)this.modifyDNRequestLength) + this.modifyDNRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes((int)this.modifyDNRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.entry));
            Value.encode((ByteBuffer)buffer, (String)this.newRDN.toString());
            Value.encode((ByteBuffer)buffer, (boolean)this.deleteOldRDN);
            if (this.newSuperior != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = LdapDN.getNbBytes(this.newSuperior);
                buffer.put(TLV.getBytes((int)newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(LdapDN.getBytes(this.newSuperior));
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ModifyDN Response\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        sb.append("        New RDN : '").append(this.newRDN).append("'\n");
        sb.append("        Delete old RDN : ").append(this.deleteOldRDN).append("\n");
        if (this.newSuperior != null) {
            sb.append("        New superior : '").append(this.newSuperior).append("'\n");
        }
        return sb.toString();
    }
}

