/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;

public class ControlCodec
extends AbstractAsn1Object {
    private String controlType;
    private boolean criticality = false;
    private Object controlValue;
    private byte[] encodedValue;
    private int controlLength;

    public String getControlType() {
        return this.controlType == null ? "" : this.controlType;
    }

    public void setControlType(String controlType) {
        this.controlType = controlType;
    }

    public Object getControlValue() {
        if (this.controlValue == null) {
            return StringTools.EMPTY_BYTES;
        }
        if (this.controlValue instanceof String) {
            return StringTools.getBytesUtf8((String)this.controlValue);
        }
        return this.controlValue;
    }

    public void setEncodedValue(byte[] encodedValue) {
        if (encodedValue != null) {
            this.encodedValue = new byte[encodedValue.length];
            System.arraycopy(encodedValue, 0, this.encodedValue, 0, encodedValue.length);
        } else {
            this.encodedValue = null;
        }
    }

    public byte[] getEncodedValue() {
        if (this.encodedValue == null) {
            return StringTools.EMPTY_BYTES;
        }
        byte[] copy = new byte[this.encodedValue.length];
        System.arraycopy(this.encodedValue, 0, copy, 0, this.encodedValue.length);
        return copy;
    }

    public void setControlValue(Object controlValue) {
        this.controlValue = controlValue;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    public void setCriticality(boolean criticality) {
        this.criticality = criticality;
    }

    public int computeLength() {
        int controlTypeLengh = StringTools.getBytesUtf8(this.controlType).length;
        this.controlLength = 1 + TLV.getNbBytes((int)controlTypeLengh) + controlTypeLengh;
        if (this.criticality) {
            this.controlLength += 3;
        }
        if (this.controlValue != null) {
            if (this.controlValue instanceof byte[]) {
                byte[] controlBytes = (byte[])this.controlValue;
                this.controlLength += 1 + TLV.getNbBytes((int)controlBytes.length) + controlBytes.length;
            } else if (this.controlValue instanceof String) {
                byte[] controlBytes = StringTools.getBytesUtf8((String)this.controlValue);
                this.controlLength += 1 + TLV.getNbBytes((int)controlBytes.length) + controlBytes.length;
            } else if (this.controlValue instanceof Asn1Object) {
                int length = ((Asn1Object)this.controlValue).computeLength();
                this.controlLength += 1 + TLV.getNbBytes((int)length) + length;
            } else {
                throw new IllegalStateException("Don't know how to handle control value class " + this.controlValue.getClass());
            }
        }
        return 1 + TLV.getNbBytes((int)this.controlLength) + this.controlLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.controlLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (byte[])this.getControlType().getBytes());
        if (this.criticality) {
            Value.encode((ByteBuffer)buffer, (boolean)this.criticality);
        }
        if (this.controlValue != null) {
            byte[] controlBytes;
            if (this.controlValue instanceof byte[]) {
                controlBytes = (byte[])this.controlValue;
                this.encodedValue = controlBytes;
            } else if (this.controlValue instanceof String) {
                controlBytes = StringTools.getBytesUtf8((String)this.controlValue);
                this.encodedValue = controlBytes;
            } else if (this.controlValue instanceof Asn1Object) {
                controlBytes = ((Asn1Object)this.controlValue).encode(null).array();
                this.encodedValue = controlBytes;
            } else {
                throw new IllegalStateException("Don't know how to handle control value class " + this.controlValue.getClass());
            }
            Value.encode((ByteBuffer)buffer, (byte[])controlBytes);
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Control\n");
        sb.append("        Control type : '").append(this.controlType).append("'\n");
        sb.append("        Criticality : '").append(this.criticality).append("'\n");
        if (this.controlValue != null) {
            if (this.controlValue instanceof byte[]) {
                sb.append("        Control value : '").append(StringTools.dumpBytes((byte[])this.controlValue)).append("'\n");
            } else {
                sb.append("        Control value : '").append(this.controlValue).append("'\n");
            }
        }
        return sb.toString();
    }
}

