/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.proxy.JDBCMonProxy;
import com.jamonapi.proxy.MonProxy;
import com.jamonapi.proxy.Params;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MonProxyFactory {
    private static final Class[] CLASS_ARRAY = new Class[0];
    private static Params params = new Params();

    public static Object monitor(Object object) {
        if (!MonProxyFactory.isEnabled() || object == null) {
            return object;
        }
        return MonProxyFactory.monitorNoCheck(object, MonProxyFactory.getInterfaces(object.getClass()));
    }

    public static Object monitor(Object object, Class[] interfaces) {
        if (!MonProxyFactory.isEnabled() || object == null) {
            return object;
        }
        return MonProxyFactory.monitorNoCheck(object, interfaces);
    }

    private static Object monitorNoCheck(Object object, Class[] interfaces) {
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, (InvocationHandler)new MonProxy(object, params));
    }

    public static Object monitor(Object object, Class iface) {
        return MonProxyFactory.monitor(object, new Class[]{iface});
    }

    public static Connection monitor(Connection conn) {
        return (Connection)MonProxyFactory.monitorJDBC(conn);
    }

    public static ResultSet monitor(ResultSet rs) {
        return (ResultSet)MonProxyFactory.monitorJDBC(rs);
    }

    public static Statement monitor(Statement statement) {
        return (Statement)MonProxyFactory.monitorJDBC(statement);
    }

    public static PreparedStatement monitor(PreparedStatement statement) {
        return (PreparedStatement)MonProxyFactory.monitorJDBC(statement);
    }

    public static CallableStatement monitor(CallableStatement statement) {
        return (CallableStatement)MonProxyFactory.monitorJDBC(statement);
    }

    static Object monitorJDBC(Object object) {
        if (!MonProxyFactory.params.isEnabled || !MonProxyFactory.params.isSQLSummaryEnabled && !MonProxyFactory.params.isSQLDetailEnabled || object == null || object instanceof Proxy && Proxy.getInvocationHandler(object) instanceof JDBCMonProxy) {
            return object;
        }
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), MonProxyFactory.getInterfaces(object.getClass()), (InvocationHandler)new JDBCMonProxy(object, params));
    }

    public static Class[] getInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        HashSet interfaceHeirarchy = new HashSet();
        Class[] objTree = MonProxyFactory.getClassHeirarchy(cls);
        for (int i = 0; i < objTree.length; ++i) {
            MonProxyFactory.getInterfaces(objTree[i], interfaceHeirarchy);
        }
        return MonProxyFactory.toClassArray(interfaceHeirarchy);
    }

    private static Class[] toClassArray(Collection coll) {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        return coll.toArray(CLASS_ARRAY);
    }

    private static Class[] getClassHeirarchy(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        while (cls != null) {
            classes.add(cls);
            cls = cls.getSuperclass();
        }
        return MonProxyFactory.toClassArray(classes);
    }

    private static void getInterfaces(Class cls, Set heirarchy) {
        if (cls != null) {
            Class<?>[] heir = cls.getInterfaces();
            int len = heir == null ? 0 : heir.length;
            for (int i = 0; i < len; ++i) {
                heirarchy.add(heir[i]);
                MonProxyFactory.getInterfaces(heir[i], heirarchy);
            }
        }
    }

    public static int getExceptionBufferSize() {
        return MonProxyFactory.params.exceptionBuffer.getBufferSize();
    }

    public static void setExceptionBufferSize(int exceptionBufferSize) {
        MonProxyFactory.params.exceptionBuffer.setBufferSize(exceptionBufferSize);
    }

    public static void resetExceptionDetail() {
        MonProxyFactory.params.exceptionBuffer.reset();
    }

    public static boolean isInterfaceEnabled() {
        return MonProxyFactory.params.isInterfaceEnabled;
    }

    public static void enableInterface(boolean enable) {
        MonProxyFactory.params.isInterfaceEnabled = enable;
        if (enable) {
            MonProxyFactory.enable(true);
        }
    }

    public static boolean isExceptionSummaryEnabled() {
        return MonProxyFactory.params.isExceptionSummaryEnabled;
    }

    public static void enableExceptionSummary(boolean enable) {
        MonProxyFactory.params.isExceptionSummaryEnabled = enable;
        if (enable) {
            MonProxyFactory.enable(true);
        }
    }

    public static boolean isExceptionDetailEnabled() {
        return MonProxyFactory.params.isExceptionDetailEnabled;
    }

    public static void enableExceptionDetail(boolean enable) {
        MonProxyFactory.params.isExceptionDetailEnabled = enable;
        if (enable) {
            MonProxyFactory.params.exceptionBuffer.enable();
        } else {
            MonProxyFactory.params.exceptionBuffer.disable();
        }
        if (enable) {
            MonProxyFactory.enable(true);
        }
    }

    public static boolean isSQLSummaryEnabled() {
        return MonProxyFactory.params.isSQLSummaryEnabled;
    }

    public static void enableSQLSummary(boolean enable) {
        MonProxyFactory.params.isSQLSummaryEnabled = enable;
        if (enable) {
            MonProxyFactory.enable(true);
        }
    }

    public static boolean isSQLDetailEnabled() {
        return MonProxyFactory.params.isSQLDetailEnabled;
    }

    public static void enableSQLDetail(boolean enable) {
        MonProxyFactory.params.isSQLDetailEnabled = enable;
        if (enable) {
            MonProxyFactory.params.sqlBuffer.enable();
        } else {
            MonProxyFactory.params.sqlBuffer.disable();
        }
        if (enable) {
            MonProxyFactory.enable(true);
        }
    }

    public static boolean isResultSetEnabled() {
        return MonProxyFactory.params.isResultSetEnabled;
    }

    public static void enableResultSet(boolean enable) {
        MonProxyFactory.params.isResultSetEnabled = enable;
        if (enable) {
            MonProxyFactory.enableInterface(true);
            MonProxyFactory.enable(true);
        }
    }

    public static boolean isEnabled() {
        return MonProxyFactory.params.isEnabled;
    }

    public static void enableAll(boolean enable) {
        MonProxyFactory.enable(enable);
        MonProxyFactory.enableInterface(enable);
        MonProxyFactory.enableExceptionSummary(enable);
        MonProxyFactory.enableExceptionDetail(enable);
        MonProxyFactory.enableSQLSummary(enable);
        MonProxyFactory.enableSQLDetail(enable);
        MonProxyFactory.enableResultSet(enable);
    }

    public static boolean isAllEnabled() {
        return MonProxyFactory.params.isEnabled && MonProxyFactory.params.isExceptionDetailEnabled && MonProxyFactory.params.isExceptionSummaryEnabled && MonProxyFactory.params.isSQLSummaryEnabled && MonProxyFactory.params.isSQLDetailEnabled && MonProxyFactory.params.isInterfaceEnabled && MonProxyFactory.params.isResultSetEnabled;
    }

    public static void enable(boolean enable) {
        MonProxyFactory.params.isEnabled = enable;
    }

    static Params getParams() {
        return params;
    }

    public static String[] getExceptionDetailHeader() {
        return MonProxyFactory.params.exceptionBuffer.getHeader();
    }

    public static Object[][] getExceptionDetail() {
        return MonProxyFactory.params.exceptionBuffer.getData();
    }

    public static int getSQLBufferSize() {
        return MonProxyFactory.params.sqlBuffer.getBufferSize();
    }

    public static void setSQLBufferSize(int sqlBufferSize) {
        MonProxyFactory.params.sqlBuffer.setBufferSize(sqlBufferSize);
    }

    public static void resetSQLDetail() {
        MonProxyFactory.params.sqlBuffer.reset();
    }

    public static String[] getSQLDetailHeader() {
        return MonProxyFactory.params.sqlBuffer.getHeader();
    }

    public static Object[][] getSQLDetail() {
        return MonProxyFactory.params.sqlBuffer.getData();
    }

    public static List getMatchStrings() {
        return MonProxyFactory.params.matchStrings;
    }

    public static void setMatchStrings(List ms) {
        MonProxyFactory.params.matchStrings = ms;
    }
}

