/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.field;

import edu.internet2.middleware.grouper.Field;
import edu.internet2.middleware.grouper.FieldFinder;
import edu.internet2.middleware.grouper.FieldType;
import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.exception.SchemaException;
import edu.internet2.middleware.grouper.privs.AccessPrivilege;
import edu.internet2.middleware.grouper.privs.AccessResolver;
import edu.internet2.middleware.grouper.privs.Privilege;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.BaseField;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.subject.Subject;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegeField
extends BaseField {
    private AccessResolver accessResolver;
    private Privilege privilege;

    public PrivilegeField(String id, AccessResolver accessResolver) throws GrouperException {
        super(id);
        this.accessResolver = accessResolver;
        try {
            Field field = FieldFinder.find((String)id, (boolean)true);
            if (!field.getType().equals((Object)FieldType.ACCESS)) {
                throw new GrouperException("Field '" + id + "' is not an access privilege");
            }
            this.privilege = AccessPrivilege.listToPriv((String)id);
            if (this.privilege == null) {
                throw new GrouperException("Unknown access privilege '" + id + "'");
            }
        }
        catch (SchemaException e) {
            throw new GrouperException("Unknown field '" + id + "'", (Throwable)e);
        }
    }

    public BaseAttribute<Subject> getAttribute(Group group) {
        Set subjects = this.accessResolver.getSubjectsWithPrivilege(group, this.privilege);
        this.filterInternalSubjects(subjects);
        if (!subjects.isEmpty()) {
            BasicAttribute attribute = new BasicAttribute(this.getId());
            attribute.setValues((Collection)subjects);
            return attribute;
        }
        return null;
    }

    public BaseAttribute<Group> getAttribute(Subject subject) {
        Set groups = this.accessResolver.getGroupsWhereSubjectHasPrivilege(subject, this.privilege);
        if (!groups.isEmpty()) {
            BasicAttribute attribute = new BasicAttribute(this.getId());
            attribute.setValues((Collection)groups);
            return attribute;
        }
        return null;
    }

    public Set<Subject> filterInternalSubjects(Set<Subject> subjects) {
        if (subjects.contains(SubjectFinder.findRootSubject())) {
            subjects.remove(SubjectFinder.findRootSubject());
        }
        if (subjects.contains(SubjectFinder.findAllSubject())) {
            subjects.remove(SubjectFinder.findAllSubject());
        }
        return subjects;
    }
}

