/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.field;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.BaseMembershipField;
import edu.internet2.middleware.grouper.shibboleth.filter.GroupQueryFilter;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsField
extends BaseMembershipField {
    public static final String NAME = "groups";

    public GroupsField(String id) throws GrouperException {
        super(id);
    }

    public BaseAttribute<Group> getAttribute(Member member) {
        return this.getAttribute(member, null);
    }

    public BaseAttribute<Group> getAttribute(Member member, GroupQueryFilter groupQueryFilter) {
        TreeSet<Group> groups = new TreeSet<Group>(this.getMemberFilter().getGroups(member, this.getField()));
        if (groups.isEmpty()) {
            return null;
        }
        if (groupQueryFilter != null) {
            TreeSet<Group> newGroups = new TreeSet<Group>();
            for (Group group : groups) {
                if (!groupQueryFilter.matchesGroup(group)) continue;
                newGroups.add(group);
            }
            if (newGroups.isEmpty()) {
                return null;
            }
            groups = newGroups;
        }
        BasicAttribute list = new BasicAttribute(this.getId());
        list.setValues(groups);
        return list;
    }
}

