/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.field;

import edu.internet2.middleware.grouper.Field;
import edu.internet2.middleware.grouper.FieldFinder;
import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.exception.SchemaException;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.BaseField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.FieldMemberFilter;
import java.util.Arrays;

public abstract class BaseMembershipField
extends BaseField {
    private Field field;
    private FieldMemberFilter memberFilter = FieldMemberFilter.all;

    public BaseMembershipField(String id) throws GrouperException {
        super(id);
        if (this.getIdElements().size() > 1) {
            try {
                this.memberFilter = FieldMemberFilter.valueOf(this.getSecondIdElement());
                if (this.getSecondIdElement().equals("composite")) {
                    throw new GrouperException("Composite memberships are not currently supported.");
                }
            }
            catch (IllegalArgumentException e) {
                throw new GrouperException("Unknown filter value, should be one of " + Arrays.asList(FieldMemberFilter.values()), (Throwable)e);
            }
        }
        String fieldName = "members";
        if (this.getIdElements().size() == 3) {
            fieldName = this.getThirdIdElement();
        }
        try {
            this.field = FieldFinder.find((String)fieldName, (boolean)true);
        }
        catch (SchemaException e) {
            throw new GrouperException("Unknown field '" + fieldName + "'", (Throwable)e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public FieldMemberFilter getMemberFilter() {
        return this.memberFilter;
    }
}

