/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector;

import edu.internet2.middleware.grouper.GrouperSession;
import edu.internet2.middleware.grouper.Stem;
import edu.internet2.middleware.grouper.StemFinder;
import edu.internet2.middleware.grouper.attr.AttributeDefName;
import edu.internet2.middleware.grouper.exception.GrouperSessionException;
import edu.internet2.middleware.grouper.misc.GrouperSessionHandler;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.BaseGrouperDataConnector;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StemDataConnector
extends BaseGrouperDataConnector {
    private static final Logger LOG = LoggerFactory.getLogger(StemDataConnector.class);
    private Stem rootStem;

    public Map<String, BaseAttribute> resolve(final ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        Map attributes = (Map)GrouperSession.callbackGrouperSession((GrouperSession)this.getGrouperSession(), (GrouperSessionHandler)new GrouperSessionHandler(){

            public Map<String, BaseAttribute> callback(GrouperSession grouperSession) throws GrouperSessionException {
                Stem parentStem;
                String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
                String msg = "'" + principalName + "' dc '" + StemDataConnector.this.getId() + "'";
                LOG.debug("resolve {}", (Object)msg);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("resolve {} requested attribute ids {}", (Object)msg, (Object)resolutionContext.getAttributeRequestContext().getRequestedAttributesIds());
                    if (resolutionContext.getAttributeRequestContext().getRequestedAttributesIds() != null) {
                        for (String attrId : resolutionContext.getAttributeRequestContext().getRequestedAttributesIds()) {
                            LOG.trace("resolve {} requested attribute '{}'", (Object)msg, (Object)attrId);
                        }
                    }
                }
                HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
                Stem stem = StemFinder.findByName((GrouperSession)StemDataConnector.this.getGrouperSession(), (String)principalName, (boolean)false);
                if (stem == null) {
                    LOG.debug("resolve {} stem not found", (Object)msg);
                    return attributes;
                }
                LOG.debug("resolve {} found stem '{}'", (Object)msg, (Object)stem);
                if (stem.equals((Object)StemDataConnector.this.getRootStem())) {
                    LOG.debug("resolve {} returning empty map for root stem", (Object)msg);
                    return attributes;
                }
                BasicAttribute extension = new BasicAttribute("extension");
                extension.setValues((Collection)GrouperUtil.toList((Object[])new String[]{stem.getExtension()}));
                attributes.put(extension.getId(), (BaseAttribute)extension);
                BasicAttribute displayExtension = new BasicAttribute("displayExtension");
                displayExtension.setValues((Collection)GrouperUtil.toList((Object[])new String[]{stem.getDisplayExtension()}));
                attributes.put(displayExtension.getId(), (BaseAttribute)displayExtension);
                BasicAttribute name = new BasicAttribute("name");
                name.setValues((Collection)GrouperUtil.toList((Object[])new String[]{stem.getName()}));
                attributes.put(name.getId(), (BaseAttribute)name);
                BasicAttribute displayName = new BasicAttribute("displayName");
                displayName.setValues((Collection)GrouperUtil.toList((Object[])new String[]{stem.getDisplayName()}));
                attributes.put(displayName.getId(), (BaseAttribute)displayName);
                String description = stem.getDescription();
                if (description != null && !description.equals("")) {
                    BasicAttribute descriptionAttr = new BasicAttribute("description");
                    descriptionAttr.setValues((Collection)GrouperUtil.toList((Object[])new String[]{description}));
                    attributes.put(descriptionAttr.getId(), (BaseAttribute)descriptionAttr);
                }
                if (!(parentStem = stem.getParentStem()).equals((Object)StemDataConnector.this.getRootStem())) {
                    BasicAttribute parentStemNameAttr = new BasicAttribute("parentStemName");
                    parentStemNameAttr.setValues((Collection)GrouperUtil.toList((Object[])new String[]{parentStem.getName()}));
                    attributes.put(parentStemNameAttr.getId(), (BaseAttribute)parentStemNameAttr);
                }
                Set attributeDefNames = stem.getAttributeDelegate().retrieveAttributes();
                for (AttributeDefName attributeDefName : attributeDefNames) {
                    List values = stem.getAttributeValueDelegate().retrieveValuesString(attributeDefName.getName());
                    if (values == null || values.isEmpty()) continue;
                    BasicAttribute basicAttribute = new BasicAttribute(attributeDefName.getName());
                    basicAttribute.setValues((Collection)values);
                    attributes.put(attributeDefName.getName(), (BaseAttribute)basicAttribute);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resolve {} attributes {}", (Object)msg, (Object)attributes.size());
                    for (String key : attributes.keySet()) {
                        for (Object value : ((BaseAttribute)attributes.get(key)).getValues()) {
                            LOG.debug("resolve {} '{}' : {}", new Object[]{msg, key, value});
                        }
                    }
                }
                return attributes;
            }
        });
        return attributes;
    }

    public void validate() throws AttributeResolutionException {
    }

    private Stem getRootStem() {
        if (this.rootStem == null) {
            this.rootStem = (Stem)GrouperSession.callbackGrouperSession((GrouperSession)this.getGrouperSession(), (GrouperSessionHandler)new GrouperSessionHandler(){

                public Stem callback(GrouperSession grouperSession) throws GrouperSessionException {
                    return StemFinder.findRootStem((GrouperSession)grouperSession);
                }
            });
        }
        return this.rootStem;
    }

    @Override
    public Set<String> getAllIdentifiers() {
        return this.getAllIdentifiers(null);
    }

    @Override
    public Set<String> getAllIdentifiers(Date updatedSince) {
        TreeSet<String> identifiers = new TreeSet<String>();
        for (String stemName : GrouperUtil.findParentStemNames(this.getGroups(updatedSince))) {
            if (stemName.equals(":")) continue;
            identifiers.add(stemName);
        }
        return identifiers;
    }
}

