/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.GrouperSession;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.MemberFinder;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.attr.AttributeDefName;
import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.exception.GrouperSessionException;
import edu.internet2.middleware.grouper.misc.GrouperSessionHandler;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.BaseGrouperDataConnector;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.GroupsField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.PrivilegeField;
import edu.internet2.middleware.grouper.shibboleth.util.AttributeIdentifier;
import edu.internet2.middleware.grouper.shibboleth.util.SourceIdentifier;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.subject.SourceUnavailableException;
import edu.internet2.middleware.subject.Subject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberDataConnector
extends BaseGrouperDataConnector {
    private static final Logger LOG = LoggerFactory.getLogger(MemberDataConnector.class);
    public static final String ID_ATTRIBUTE_NAME = "id";
    private Set<SourceIdentifier> sourceIdentifiers;
    private Set<String> stringSourceIdentifiers;

    public Set<SourceIdentifier> getSourceIdentifiers() {
        return this.sourceIdentifiers;
    }

    public void setSourceIdentifiers(Set<SourceIdentifier> sourceIdentifiers) {
        this.sourceIdentifiers = sourceIdentifiers;
    }

    private Set<String> getSourceIdentifiersAsStrings() {
        if (this.stringSourceIdentifiers == null && this.sourceIdentifiers != null && !this.sourceIdentifiers.isEmpty()) {
            this.stringSourceIdentifiers = new HashSet<String>();
            for (SourceIdentifier sourceIdentifier : this.sourceIdentifiers) {
                this.stringSourceIdentifiers.add(sourceIdentifier.getId());
            }
        }
        return this.stringSourceIdentifiers;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getSourceIdentifiersAsStrings() != null) {
            for (String sourceId : this.getSourceIdentifiersAsStrings()) {
                try {
                    if (SubjectFinder.getSource((String)sourceId) != null) continue;
                    LOG.error("Unknown source '" + sourceId + "'");
                    throw new GrouperException("Unknown source '" + sourceId + "'");
                }
                catch (SourceUnavailableException e) {
                    LOG.error("Source unavailable '" + sourceId + "'", (Throwable)e);
                    throw new GrouperException("Source unavailable '" + sourceId + "'", (Throwable)e);
                }
            }
        }
    }

    public Map<String, BaseAttribute> resolve(final ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        Map attributes = (Map)GrouperSession.callbackGrouperSession((GrouperSession)this.getGrouperSession(), (GrouperSessionHandler)new GrouperSessionHandler(){

            public Map<String, BaseAttribute> callback(GrouperSession grouperSession) throws GrouperSessionException {
                BaseAttribute<Group> attr;
                String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
                String msg = "'" + principalName + "' dc '" + MemberDataConnector.this.getId() + "'";
                LOG.debug("resolve {}", (Object)msg);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("resolve {} requested attribute ids {}", (Object)msg, (Object)resolutionContext.getAttributeRequestContext().getRequestedAttributesIds());
                    if (resolutionContext.getAttributeRequestContext().getRequestedAttributesIds() != null) {
                        for (String attrId : resolutionContext.getAttributeRequestContext().getRequestedAttributesIds()) {
                            LOG.trace("resolve {} requested attribute '{}'", (Object)msg, (Object)attrId);
                        }
                    }
                }
                HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
                Subject subject = SubjectFinder.findByIdOrIdentifier((String)principalName, (boolean)false);
                if (subject == null) {
                    LOG.debug("resolve {} subject not found", (Object)msg);
                    return attributes;
                }
                LOG.debug("resolve {} found subject '{}'", (Object)msg, (Object)GrouperUtil.subjectToString((Subject)subject));
                if (subject.getSourceId().equals(SubjectFinder.internal_getGSA().getId())) {
                    LOG.debug("resolve {} returning empty map for '{}' source", (Object)msg, (Object)SubjectFinder.internal_getGSA().getId());
                    return attributes;
                }
                if (MemberDataConnector.this.getSourceIdentifiersAsStrings() != null && !MemberDataConnector.this.getSourceIdentifiersAsStrings().contains(subject.getSourceId())) {
                    LOG.debug("resolve {} returning empty map for unknown source '{}'", (Object)msg, (Object)subject.getSourceId());
                    return attributes;
                }
                Member member = MemberFinder.findBySubject((GrouperSession)MemberDataConnector.this.getGrouperSession(), (Subject)subject, (boolean)false);
                if (member == null) {
                    LOG.debug("resolve {} member not found", (Object)msg);
                    return attributes;
                }
                LOG.debug("resolve {} found member '{}'", (Object)msg, (Object)member);
                BasicAttribute id = new BasicAttribute(MemberDataConnector.ID_ATTRIBUTE_NAME);
                id.setValues(Arrays.asList(subject.getId()));
                attributes.put(id.getId(), (BaseAttribute)id);
                LOG.debug("resolve {} subjectIDs {}", (Object)msg, MemberDataConnector.this.getSubjectAttributeIdentifiers());
                for (AttributeIdentifier attributeIdentifier : MemberDataConnector.this.getSubjectAttributeIdentifiers()) {
                    LOG.debug("resolve {} member {} field {}", new Object[]{msg, member, attributeIdentifier});
                    if (!subject.getSourceId().equals(attributeIdentifier.getSource())) continue;
                    if (attributeIdentifier.getId().equals("name")) {
                        String name = subject.getName();
                        if (name == null) continue;
                        BasicAttribute nameAttribute = new BasicAttribute("name");
                        nameAttribute.setValues((Collection)GrouperUtil.toList((Object[])new String[]{name}));
                        attributes.put(nameAttribute.getId(), (BaseAttribute)nameAttribute);
                        continue;
                    }
                    if (attributeIdentifier.getId().equals("description")) {
                        String description = subject.getDescription();
                        if (description == null || description.equals("")) continue;
                        BasicAttribute descriptionAttribute = new BasicAttribute("description");
                        descriptionAttribute.setValues((Collection)GrouperUtil.toList((Object[])new String[]{description}));
                        attributes.put(descriptionAttribute.getId(), (BaseAttribute)descriptionAttribute);
                        continue;
                    }
                    Set values = subject.getAttributeValues(attributeIdentifier.getId());
                    if (values == null || values.isEmpty()) continue;
                    BasicAttribute basicAttribute = new BasicAttribute(attributeIdentifier.getId());
                    basicAttribute.setValues((Collection)values);
                    attributes.put(basicAttribute.getId(), (BaseAttribute)basicAttribute);
                }
                for (GroupsField groupsField : MemberDataConnector.this.getGroupsFields()) {
                    attr = groupsField.getAttribute(member, MemberDataConnector.this.getGroupQueryFilter());
                    if (attr == null) continue;
                    attributes.put(groupsField.getId(), attr);
                }
                for (PrivilegeField privilegeField : MemberDataConnector.this.getPrivilegeFields()) {
                    attr = privilegeField.getAttribute(subject);
                    if (attr == null) continue;
                    attributes.put(privilegeField.getId(), attr);
                }
                Set attributeDefNames = member.getAttributeDelegate().retrieveAttributes();
                for (AttributeDefName attributeDefName : attributeDefNames) {
                    List values = member.getAttributeValueDelegate().retrieveValuesString(attributeDefName.getName());
                    if (values == null || values.isEmpty()) continue;
                    BasicAttribute basicAttribute = new BasicAttribute(attributeDefName.getName());
                    basicAttribute.setValues((Collection)values);
                    attributes.put(attributeDefName.getName(), (BaseAttribute)basicAttribute);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resolve {} attributes {}", (Object)msg, (Object)attributes.size());
                    for (String key : attributes.keySet()) {
                        for (Object value : ((BaseAttribute)attributes.get(key)).getValues()) {
                            LOG.debug("resolve {} '{}' : {}", new Object[]{msg, key, value});
                        }
                    }
                }
                return attributes;
            }
        });
        return attributes;
    }

    public void validate() throws AttributeResolutionException {
    }

    @Override
    public Set<String> getAllIdentifiers() {
        return this.getAllIdentifiers(null);
    }

    @Override
    public Set<String> getAllIdentifiers(Date updatedSince) {
        TreeSet<String> identifiers = new TreeSet<String>();
        for (Group group : this.getGroups(updatedSince)) {
            for (Member member : this.getMembers(group)) {
                if (member.getSubjectSourceId().equals("g:gsa")) continue;
                identifiers.add(member.getSubjectId());
            }
        }
        return identifiers;
    }

    public Set<Member> getMembers(final Group group) {
        return (Set)GrouperSession.callbackGrouperSession((GrouperSession)this.getGrouperSession(), (GrouperSessionHandler)new GrouperSessionHandler(){

            public Set<Member> callback(GrouperSession grouperSession) throws GrouperSessionException {
                return group.getMembers();
            }
        });
    }
}

