/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.attribute;

import edu.internet2.middleware.shibboleth.common.attribute.AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethAttributeFilteringEngine;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethAttributeResolver;
import edu.internet2.middleware.shibboleth.common.config.BaseService;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAttributeAuthority
extends BaseService
implements AttributeAuthority<SAMLProfileRequestContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAttributeAuthority.class);
    private ShibbolethAttributeResolver attributeResolver;
    private ShibbolethAttributeFilteringEngine filteringEngine;

    public SimpleAttributeAuthority(ShibbolethAttributeResolver resolver) {
        this.attributeResolver = resolver;
    }

    public ShibbolethAttributeFilteringEngine getFilteringEngine() {
        return this.filteringEngine;
    }

    public void setFilteringEngine(ShibbolethAttributeFilteringEngine engine) {
        this.filteringEngine = engine;
    }

    public Map<String, BaseAttribute> getAttributes(SAMLProfileRequestContext requestContext) throws AttributeRequestException {
        String principalName = requestContext.getPrincipalName();
        String msg = "get attributes '" + principalName + "' aa '" + this.getId() + "'";
        LOG.debug("{}", (Object)msg);
        if (LOG.isTraceEnabled() && requestContext.getRequestedAttributesIds() != null) {
            for (String attrId : requestContext.getRequestedAttributesIds()) {
                LOG.trace("resolve {} requested attribute '{}'", (Object)msg, (Object)attrId);
            }
        }
        Map attributes = this.attributeResolver.resolveAttributes(requestContext);
        if (this.filteringEngine != null) {
            attributes = this.filteringEngine.filterAttributes(attributes, requestContext);
        }
        if (LOG.isDebugEnabled()) {
            for (String key : attributes.keySet()) {
                for (Object value : ((BaseAttribute)attributes.get(key)).getValues()) {
                    LOG.debug("{} returned '{}' : {}", new Object[]{msg, key, value});
                }
            }
        }
        return attributes;
    }

    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
    }
}

