/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcReplyEncoder {
    public void encode(KdcReply app, ByteBuffer out) throws IOException {
        ASN1OutputStream aos = new ASN1OutputStream(out);
        DERSequence kdcrep = this.encodeKdcReplySequence(app);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)app.getMessageType().getOrdinal(), (DEREncodable)kdcrep));
        aos.close();
    }

    private DERSequence encodeKdcReplySequence(KdcReply app) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)app.getProtocolVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)app.getMessageType().getOrdinal())));
        if (app.getPaData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)this.encodePreAuthData(app.getPaData())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)DERGeneralString.valueOf((String)app.getClientRealm().toString())));
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)PrincipalNameEncoder.encode(app.getClientPrincipal())));
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)TicketEncoder.encode(app.getTicket())));
        sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)EncryptedDataEncoder.encodeSequence(app.getEncPart())));
        return sequence;
    }

    private DERSequence encodePreAuthData(PaData[] preAuthData) {
        DERSequence preAuth = new DERSequence();
        for (int ii = 0; ii < preAuthData.length; ++ii) {
            DERSequence sequence = new DERSequence();
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)preAuthData[ii].getPaDataType().getOrdinal())));
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DEROctetString(preAuthData[ii].getPaDataValue())));
            preAuth.add((DEREncodable)sequence);
        }
        return preAuth;
    }
}

