/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KerberosMessageType {
    AS_REQ(10, "initial authentication request"),
    AS_REP(11, "initial authentication response"),
    TGS_REQ(12, "request for authentication based on TGT"),
    TGS_REP(13, "response to authentication based on TGT"),
    AP_REQ(14, "application request"),
    AP_REP(15, "application response"),
    KRB_SAFE(20, "safe (checksummed) application message"),
    KRB_PRIV(21, "private (encrypted) application message"),
    KRB_CRED(22, "private (encrypted) message to forward credentials"),
    ENC_AP_REP_PART(27, "encrypted application reply part"),
    ENC_PRIV_PART(28, "encrypted private message part"),
    KRB_ERROR(30, "error response");

    private int value;
    private String message;

    private KerberosMessageType(int value, String message) {
        this.value = value;
        this.message = message;
    }

    public int getOrdinal() {
        return this.value;
    }

    public String getMessage() {
        return this.message;
    }

    public static KerberosMessageType getTypeByOrdinal(int value) {
        switch (value) {
            case 10: {
                return AS_REQ;
            }
            case 11: {
                return AS_REP;
            }
            case 12: {
                return TGS_REQ;
            }
            case 13: {
                return TGS_REP;
            }
            case 14: {
                return AP_REQ;
            }
            case 15: {
                return AP_REP;
            }
            case 20: {
                return KRB_SAFE;
            }
            case 21: {
                return KRB_PRIV;
            }
            case 22: {
                return KRB_CRED;
            }
            case 27: {
                return ENC_AP_REP_PART;
            }
            case 28: {
                return ENC_PRIV_PART;
            }
            case 30: {
                return KRB_ERROR;
            }
        }
        return null;
    }
}

