/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.cursor;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.shared.ldap.cursor.AbstractCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCursor<E>
extends AbstractCursor<E> {
    private final List<E> list;
    private final Comparator<E> comparator;
    private final int start;
    private final int end;
    private int index = -1;

    public ListCursor(Comparator<E> comparator, int start, List<E> list, int end) {
        if (start < 0 || start > list.size()) {
            throw new IllegalArgumentException("start index '" + start + "' out of range");
        }
        if (end < 0 || end > list.size()) {
            throw new IllegalArgumentException("end index '" + end + "' out of range");
        }
        if (list.size() > 0 && start >= end) {
            throw new IllegalArgumentException("start index '" + start + "' greater than or equal to end index '" + end + "' just does not make sense");
        }
        this.comparator = comparator;
        this.list = list != null ? list : Collections.emptyList();
        this.start = start;
        this.end = end;
    }

    public ListCursor(int start, List<E> list, int end) {
        this(null, start, list, end);
    }

    public ListCursor(List<E> list, int end) {
        this(null, 0, list, end);
    }

    public ListCursor(Comparator<E> comparator, List<E> list, int end) {
        this(comparator, 0, list, end);
    }

    public ListCursor(int start, List<E> list) {
        this(null, start, list, list.size());
    }

    public ListCursor(Comparator<E> comparator, int start, List<E> list) {
        this(comparator, start, list, list.size());
    }

    public ListCursor(List<E> list) {
        this(null, 0, list, list.size());
    }

    public ListCursor(Comparator<E> comparator, List<E> list) {
        this(comparator, 0, list, list.size());
    }

    public ListCursor() {
        this(null, 0, Collections.EMPTY_LIST, 0);
    }

    public ListCursor(Comparator<E> comparator) {
        this(comparator, 0, Collections.EMPTY_LIST, 0);
    }

    @Override
    public boolean available() {
        return this.index >= 0 && this.index < this.end;
    }

    @Override
    public void before(E element) throws Exception {
        this.checkNotClosed("before()");
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.list.size() == 0) {
            return;
        }
        if (this.list.size() == 1) {
            if (this.comparator.compare(element, this.list.get(0)) <= 0) {
                this.beforeFirst();
            } else {
                this.afterLast();
            }
        }
        throw new UnsupportedOperationException("don't know if list is sorted and checking that is not worth it");
    }

    @Override
    public void after(E element) throws Exception {
        this.checkNotClosed("after()");
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.list.size() == 0) {
            return;
        }
        if (this.list.size() == 1) {
            if (this.comparator.compare(element, this.list.get(0)) >= 0) {
                this.afterLast();
            } else {
                this.beforeFirst();
            }
        }
        throw new UnsupportedOperationException("don't know if list is sorted and checking that is not worth it");
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.index = -1;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.index = this.end;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        if (this.list.size() > 0) {
            this.index = this.start;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        if (this.list.size() > 0) {
            this.index = this.end - 1;
            return true;
        }
        return false;
    }

    public boolean isFirst() throws Exception {
        this.checkNotClosed("isFirst()");
        return this.list.size() > 0 && this.index == this.start;
    }

    public boolean isLast() throws Exception {
        this.checkNotClosed("isLast()");
        return this.list.size() > 0 && this.index == this.end - 1;
    }

    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("isAfterLast()");
        return this.index == this.end;
    }

    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("isBeforeFirst()");
        return this.index == -1;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.index == -1) {
            return false;
        }
        if (this.index - 1 >= this.start) {
            --this.index;
            return true;
        }
        if (this.index <= this.start) {
            this.index = -1;
            return false;
        }
        if (this.list.size() <= 0) {
            this.index = -1;
        }
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.list.size() > 0 && this.index == -1) {
            this.index = this.start;
            return true;
        }
        if (this.list.size() > 0 && this.index + 1 < this.end) {
            ++this.index;
            return true;
        }
        if (this.list.size() > 0 && this.index + 1 == this.end) {
            ++this.index;
            return false;
        }
        if (this.list.size() <= 0) {
            this.index = this.end;
        }
        return false;
    }

    @Override
    public E get() throws Exception {
        this.checkNotClosed("get()");
        if (this.index < this.start || this.index >= this.end) {
            throw new IOException("Cursor not positioned at an element");
        }
        return this.list.get(this.index);
    }

    @Override
    public boolean isElementReused() {
        return true;
    }
}

